/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JButton;

public class MagneticFieldBarAP
extends AP6
implements MouseListener,
MouseMotionListener {
    static final String[][] text = new String[][]{{"de", "Magnetfeld eines Stabmagneten", "Feldlinien l\u00f6schen", "Magnet umdrehen", ""}, {"en", "Magnetic Field of a Bar Magnet", "Clear field lines", "Turn magnet", ""}};
    private int[] gaps = new int[]{10, 10, 160, 0, 10};
    final int width = 800;
    final int height = 400;
    final int width0 = 600;
    FontMetrics fmH;
    CanvasAP cv;
    Panel6 pan;
    JButton buReset;
    JButton buDir;
    Color bgCanvas;
    Color bgPanel;
    Color colorButton1;
    Color colorButton2;
    Color colorNorth;
    Color colorSouth;
    Color colorField;
    String coauthor;
    String text01;
    String text02;
    final int lMag = 100;
    final int lMagH = 50;
    final int wMag = 20;
    final int wMagH = 10;
    final int hMag = 10;
    final int hMagH = 5;
    int ux;
    int uy;
    Image iFix;
    Graphics2D gFix;
    int dir;
    double[] needle;
    double[] field;
    double[] pNx;
    double[] pNy;
    double[] pSx;
    double[] pSy;
    boolean moved;
    boolean neu;

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(800, 400);
    }

    @Override
    protected void initAttributes() {
        this.dir = 1;
        this.ux = 300;
        this.uy = 200;
        this.moved = false;
        this.field = new double[3];
        this.needle = new double[3];
        this.needle[0] = 100.0;
        this.needle[1] = 0.0;
        this.pNx = new double[3];
        this.pNy = new double[3];
        this.pSx = new double[3];
        this.pSy = new double[3];
        this.neu = true;
    }

    @Override
    protected void initColors() {
        this.bgCanvas = this.getColor(Color.yellow, "bgCanvas");
        this.bgPanel = this.getColor(Color.green, "bgPanel");
        this.colorButton1 = this.getColor(Color.cyan, "colorButton1");
        this.colorButton2 = this.getColor(new Color(255, 64, 64), "colorButton2");
        this.colorNorth = this.getColor(Color.red, "colorNorth");
        this.colorSouth = this.getColor(Color.green, "colorSouth");
        this.colorField = this.getColor(Color.blue, "colorField");
    }

    @Override
    protected void initText() {
        String[] t = this.searchLanguage(text, "en");
        this.language = this.getText(this.language, "language");
        this.title = this.getText(t[1], "title");
        this.text01 = this.getText(t[2], "text01");
        this.text02 = this.getText(t[3], "text02");
        this.coauthor = this.getText(t[4], "coauthor");
    }

    @Override
    protected void initCanvas() {
        this.cv = new CanvasAP(this);
        this.cv.setBounds(0, 0, 600, 400);
        this.add(this.cv);
        this.cv.addMouseListener(this);
        this.cv.addMouseMotionListener(this);
    }

    @Override
    protected void initPanel() {
        this.pan = new Panel6(this, this.bgPanel, 3, this.gaps);
        this.pan.setBounds(600, 0, 200, 400);
        this.buReset = this.pan.newButton(this.text01, this.colorButton1);
        this.buDir = this.pan.newButton(this.text02, this.colorButton2);
        this.pan.add(2001);
        this.pan.add(this.coauthor);
        this.add(this.pan);
    }

    @Override
    public void run() {
    }

    void addField(double x, double y, double z, int dir, double[] pos, double[] field) {
        double rx = pos[0] - x;
        double ry = pos[1] - y;
        double rz = -z;
        double r3 = rx * rx + ry * ry + rz * rz;
        r3 *= Math.sqrt(r3);
        rx /= r3;
        ry /= r3;
        rz /= r3;
        switch (dir) {
            case 0: {
                field[1] = field[1] - rz;
                field[2] = field[2] + ry;
                break;
            }
            case 1: {
                field[0] = field[0] + rz;
                field[2] = field[2] - rx;
                break;
            }
            case 2: {
                field[0] = field[0] - ry;
                field[1] = field[1] + rx;
                break;
            }
            case 3: {
                field[1] = field[1] + rz;
                field[2] = field[2] - ry;
                break;
            }
            case 4: {
                field[0] = field[0] - rz;
                field[2] = field[2] + rx;
                break;
            }
            case 5: {
                field[0] = field[0] + ry;
                field[1] = field[1] - rx;
            }
        }
    }

    void calcField(double[] pos, int dist, double[] field) {
        double d = (double)dist / 2.0;
        field[1] = 0.0;
        field[0] = 0.0;
        int iMax = 100 / dist - 1;
        int jMax = 20 / dist - 1;
        int kMax = 10 / dist - 1;
        for (int i = -iMax; i <= iMax; i += 2) {
            double id = (double)i * d;
            for (int k = -kMax; k <= kMax; k += 2) {
                double kd = (double)k * d;
                this.addField(id, -10.0, kd, this.dir > 0 ? 5 : 2, pos, field);
                this.addField(id, 10.0, kd, this.dir > 0 ? 2 : 5, pos, field);
            }
            for (int j = -jMax; j <= jMax; j += 2) {
                double jd = (double)j * d;
                this.addField(id, jd, 5.0, this.dir > 0 ? 4 : 1, pos, field);
                this.addField(id, jd, -5.0, this.dir > 0 ? 1 : 4, pos, field);
            }
        }
    }

    void setPoint(double[] px, double[] py, int i, double x, double y) {
        px[i] = x;
        py[i] = y;
    }

    boolean isInside(double x, double y, double dist) {
        return Math.abs(x) <= 50.0 + dist && Math.abs(y) <= 10.0 + dist;
    }

    void paintFix() {
        CanvasAP.rectangle(this.gFix, 0.0, 0.0, 600.0, 400.0, this.bgCanvas);
        CanvasAP.rectangle(this.gFix, this.ux - 25 * (1 + this.dir), this.uy - 10, 50.0, 20.0, this.colorNorth, true);
        CanvasAP.rectangle(this.gFix, this.ux - 25 * (1 - this.dir), this.uy - 10, 50.0, 20.0, this.colorSouth, true);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.buDir) {
            this.dir = -this.dir;
        }
        this.needle[0] = 100.0;
        this.needle[1] = 0.0;
        this.paintFix();
        this.cv.repaint();
    }

    @Override
    public void mousePressed(MouseEvent me) {
        double dy;
        double dx = (double)this.ux + this.needle[0] - (double)me.getX();
        if (dx * dx + (dy = (double)this.uy - this.needle[1] - (double)me.getY()) * dy <= 100.0) {
            this.moved = true;
        }
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        double x = me.getX() - this.ux;
        double y = this.uy - me.getY();
        if (this.moved && !this.isInside(x, y, 5.0)) {
            this.cv.fieldLine(this.gFix, x, y, 5);
            this.needle[0] = x;
            this.needle[1] = y;
        }
        this.moved = false;
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        if (!this.moved) {
            return;
        }
        double[] h1 = new double[3];
        double[] h2 = new double[3];
        h1[0] = me.getX() - this.ux;
        h1[1] = this.uy - me.getY();
        h1[2] = 0.0;
        if (this.isInside(h1[0], h1[1], 5.0)) {
            return;
        }
        this.calcField(h1, 5, h2);
        double w = Math.atan2(h2[1], h2[0]);
        double dx = 20.0 * Math.cos(w);
        double dy = 20.0 * Math.sin(w);
        if (this.isInside(h1[0] + dx, h1[1] + dy, 0.0)) {
            return;
        }
        if (this.isInside(h1[0] - dx, h1[1] - dy, 0.0)) {
            return;
        }
        this.needle[0] = h1[0];
        this.needle[1] = h1[1];
        this.cv.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    class CanvasAP
    extends Canvas6 {
        CanvasAP(AP6 ap) {
            super(ap, MagneticFieldBarAP.this.bgCanvas);
            MagneticFieldBarAP.this.fmH = this.getFontMetrics(this.fH);
        }

        void arrow(Graphics2D g, double y) {
            if (Math.abs(y) <= 10.0 && y % 5.0 != 0.0) {
                return;
            }
            int dirArrow = Math.abs(y) <= 10.0 ? -MagneticFieldBarAP.this.dir : MagneticFieldBarAP.this.dir;
            double x0 = MagneticFieldBarAP.this.ux + dirArrow * 5;
            double y0 = (double)MagneticFieldBarAP.this.uy - y;
            double x1 = MagneticFieldBarAP.this.ux - dirArrow * 5;
            double y1 = (double)MagneticFieldBarAP.this.uy - y - 3.0;
            CanvasAP.line(g, x0, y0, x1, y1);
            y1 = (double)MagneticFieldBarAP.this.uy - y + 3.0;
            CanvasAP.line(g, x0, y0, x1, y1);
        }

        void fieldLine(Graphics2D g, double x, double y, int dist) {
            double w;
            double y0;
            double x0;
            int i;
            x = Math.abs(x);
            g.setColor(MagneticFieldBarAP.this.colorField);
            double[] pos = new double[3];
            double[] field = new double[3];
            pos[0] = x;
            pos[1] = y;
            double x1 = pos[0];
            double y1 = pos[1];
            for (i = 0; i < 1000; ++i) {
                x0 = x1;
                y0 = y1;
                MagneticFieldBarAP.this.calcField(pos, dist, field);
                w = Math.atan2(field[1], field[0]);
                pos[0] = pos[0] + Math.cos(w);
                pos[1] = pos[1] + Math.sin(w);
                x1 = pos[0];
                y1 = pos[1];
                CanvasAP.line(g, (double)MagneticFieldBarAP.this.ux + x0, (double)MagneticFieldBarAP.this.uy - y0, (double)MagneticFieldBarAP.this.ux + x1, (double)MagneticFieldBarAP.this.uy - y1);
                CanvasAP.line(g, (double)MagneticFieldBarAP.this.ux - x0, (double)MagneticFieldBarAP.this.uy - y0, (double)MagneticFieldBarAP.this.ux - x1, (double)MagneticFieldBarAP.this.uy - y1);
                if (!(x1 < 0.0)) continue;
                this.arrow(g, y1);
                break;
            }
            pos[0] = x;
            pos[1] = y;
            x1 = pos[0];
            y1 = pos[1];
            for (i = 0; i < 1000; ++i) {
                x0 = x1;
                y0 = y1;
                MagneticFieldBarAP.this.calcField(pos, dist, field);
                w = Math.atan2(field[1], field[0]);
                pos[0] = pos[0] - Math.cos(w);
                pos[1] = pos[1] - Math.sin(w);
                x1 = pos[0];
                y1 = pos[1];
                CanvasAP.line(g, (double)MagneticFieldBarAP.this.ux + x0, (double)MagneticFieldBarAP.this.uy - y0, (double)MagneticFieldBarAP.this.ux + x1, (double)MagneticFieldBarAP.this.uy - y1);
                CanvasAP.line(g, (double)MagneticFieldBarAP.this.ux - x0, (double)MagneticFieldBarAP.this.uy - y0, (double)MagneticFieldBarAP.this.ux - x1, (double)MagneticFieldBarAP.this.uy - y1);
                if (!(x1 < 0.0)) continue;
                this.arrow(g, y1);
                break;
            }
        }

        void compass(Graphics2D g) {
            double mx = (double)MagneticFieldBarAP.this.ux + MagneticFieldBarAP.this.needle[0];
            double my = (double)MagneticFieldBarAP.this.uy - MagneticFieldBarAP.this.needle[1];
            double w = Math.atan2(MagneticFieldBarAP.this.field[1], MagneticFieldBarAP.this.field[0]);
            if (MagneticFieldBarAP.this.dir < 0) {
                w += Math.PI;
            }
            double cos = Math.cos(w);
            double sin = Math.sin(w);
            double dx0 = (double)(MagneticFieldBarAP.this.dir * 20) * cos;
            double dy0 = (double)(-MagneticFieldBarAP.this.dir * 20) * sin;
            double dx1 = 4.0 * sin;
            double dy1 = 4.0 * cos;
            MagneticFieldBarAP.this.setPoint(MagneticFieldBarAP.this.pNx, MagneticFieldBarAP.this.pNy, 0, mx - dx0, my - dy0);
            MagneticFieldBarAP.this.setPoint(MagneticFieldBarAP.this.pNx, MagneticFieldBarAP.this.pNy, 1, mx - dx1, my - dy1);
            MagneticFieldBarAP.this.setPoint(MagneticFieldBarAP.this.pNx, MagneticFieldBarAP.this.pNy, 2, mx + dx1, my + dy1);
            CanvasAP.polygon(g, MagneticFieldBarAP.this.pNx, MagneticFieldBarAP.this.pNy, MagneticFieldBarAP.this.colorNorth, true);
            MagneticFieldBarAP.this.setPoint(MagneticFieldBarAP.this.pSx, MagneticFieldBarAP.this.pSy, 0, mx + dx0, my + dy0);
            MagneticFieldBarAP.this.setPoint(MagneticFieldBarAP.this.pSx, MagneticFieldBarAP.this.pSy, 1, mx + dx1, my + dy1);
            MagneticFieldBarAP.this.setPoint(MagneticFieldBarAP.this.pSx, MagneticFieldBarAP.this.pSy, 2, mx - dx1, my - dy1);
            CanvasAP.polygon(g, MagneticFieldBarAP.this.pSx, MagneticFieldBarAP.this.pSy, MagneticFieldBarAP.this.colorSouth, true);
            CanvasAP.circle(g, mx, my, 2.0, Color.black);
        }

        @Override
        public void paint(Graphics g) {
            if (MagneticFieldBarAP.this.neu) {
                MagneticFieldBarAP.this.iFix = this.createImage(600, 400);
                MagneticFieldBarAP.this.gFix = (Graphics2D)MagneticFieldBarAP.this.iFix.getGraphics();
                MagneticFieldBarAP.this.paintFix();
                MagneticFieldBarAP.this.neu = false;
            }
            super.paint(g);
            Graphics2D g2 = (Graphics2D)g;
            CanvasAP.setAntiAliasing(g2, true);
            g.setClip(2, 2, 596, 396);
            g.drawImage(MagneticFieldBarAP.this.iFix, 0, 0, this.frame);
            if (MagneticFieldBarAP.this.moved) {
                this.fieldLine(g2, MagneticFieldBarAP.this.needle[0], MagneticFieldBarAP.this.needle[1], 5);
            }
            MagneticFieldBarAP.this.calcField(MagneticFieldBarAP.this.needle, 5, MagneticFieldBarAP.this.field);
            this.compass(g2);
        }
    }
}

